/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.vm.app.services.impl;

import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.ValidationError;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsg;
import eu.europa.ec.taxud.cesop.validation.CesopValidationException;
import eu.europa.ec.taxud.cesop.validation.IPspFileValidator;
import eu.europa.ec.taxud.cesop.validation.PspValidationResult;
import eu.europa.ec.taxud.cesop.vm.app.services.impl.CsvExporter;
import eu.europa.ec.taxud.cesop.writers.ValidationMessageXmlWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.stereotype.Component;

@Component
public class ValidationRunner
implements CommandLineRunner,
ExitCodeGenerator {
    private static final String VALIDATION_FOLDER = "validation";
    private final IPspFileValidator pspValidationService;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private int exitCode = 0;

    @Autowired
    public ValidationRunner(IPspFileValidator pspValidationService) {
        this(pspValidationService, System.out, System.err);
    }

    public ValidationRunner(IPspFileValidator pspValidationService, PrintStream stdout, PrintStream stderr) {
        this.pspValidationService = pspValidationService;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public void run(String ... args) {
        if (args.length < 1 || args.length > 2) {
            this.errorMessage("Please provide correct command line parameters:\n 1) The file/folder path;\n 2) 'true' to enable saving VLDs mode (in case of folder validation).");
            return;
        }
        boolean saveVLDsEnabled = args.length > 1 && args[1].equalsIgnoreCase("true");
        File file = new File(args[0]);
        try {
            if (!file.exists()) {
                this.errorMessage("The provided path does not exist.");
                return;
            }
            if (file.isFile()) {
                this.processSingleFile(file);
            } else {
                this.stdout.println("Starting validation of folder: \"" + file.getAbsolutePath() + (saveVLDsEnabled ? "\" with saving VLDs mode" : ""));
                this.processFolder(file, saveVLDsEnabled);
            }
            this.stdout.println("Validation successfully finished.");
        }
        catch (CesopValidationException e) {
            this.errorMessage(e.getMessage());
        }
        catch (Exception e) {
            this.exitCode = 1;
            e.printStackTrace(this.stderr);
        }
    }

    private void processSingleFile(File file) throws XMLStreamException, IOException {
        try {
            PspValidationResult result = this.pspValidationService.validate(file);
            this.writeValidationReportToStdout(result.getMessageType(), result.getPaymentDataMsg(), result.getErrors());
        }
        catch (CesopValidationException e) {
            this.errorMessage(e.getMessage());
        }
    }

    private void processFolder(File folder, boolean saveVLDsEnabled) throws IOException {
        ArrayList csvDtos = new ArrayList();
        Path vldsPath = folder.toPath().resolve(VALIDATION_FOLDER).toAbsolutePath();
        if (saveVLDsEnabled) {
            FileUtils.deleteDirectory((File)vldsPath.toFile());
            Files.createDirectory(vldsPath, new FileAttribute[0]);
        }
        Files.find(Paths.get(folder.toURI()), Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && FilenameUtils.isExtension((String)path.toFile().getName(), (String)"xml"), new FileVisitOption[0]).map(Path::toFile).forEach(file -> {
            if (file.toPath().startsWith(vldsPath)) {
                return;
            }
            try {
                PspValidationResult result = this.pspValidationService.validate(file);
                String messageRefId = Optional.ofNullable(result.getPaymentDataMsg()).map(XmlPaymentDataMsg::getMessageRefId).orElse("");
                csvDtos.add(new CsvExporter.ValidationResultCsvDTO(file.getAbsolutePath(), file.length(), messageRefId, result.getResultType()));
                if (saveVLDsEnabled) {
                    this.writeValidationReportToFile(result.getMessageType(), result.getPaymentDataMsg(), result.getErrors(), folder.toPath(), file.toPath());
                }
            }
            catch (Exception e) {
                this.stderr.println(e.getMessage());
            }
        });
        Path csvPath = CsvExporter.export(csvDtos, (Path)folder.toPath());
        this.stdout.println("Generated CSV output: " + csvPath);
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private void errorMessage(String message) {
        this.exitCode = 128;
        this.stderr.println(message);
    }

    private void writeValidationReportToStdout(MessageTypeEnum messageTypeEnum, XmlPaymentDataMsg paymentDataMsg, List<ValidationError> validationErrors) throws IOException, XMLStreamException {
        this.writeValidationMessage((OutputStream)this.stdout, messageTypeEnum, paymentDataMsg, validationErrors);
    }

    private void writeValidationReportToFile(MessageTypeEnum messageTypeEnum, XmlPaymentDataMsg paymentDataMsg, List<ValidationError> validationErrors, Path folderPath, Path pmtPath) throws IOException, XMLStreamException {
        File vld = folderPath.resolve(VALIDATION_FOLDER).resolve(folderPath.toAbsolutePath().relativize(pmtPath)).toFile();
        Files.createDirectories(vld.getParentFile().toPath(), new FileAttribute[0]);
        this.writeValidationMessage((OutputStream)new FileOutputStream(vld), messageTypeEnum, paymentDataMsg, validationErrors);
        this.stdout.println("Generated VLD file: " + vld);
    }

    private void writeValidationMessage(OutputStream outputStream, MessageTypeEnum messageTypeEnum, XmlPaymentDataMsg paymentDataMsg, List<ValidationError> validationErrors) throws XMLStreamException, IOException {
        try (ValidationMessageXmlWriter validationMessageXmlWriter = new ValidationMessageXmlWriter(outputStream);){
            if (messageTypeEnum == MessageTypeEnum.PNG) {
                validationMessageXmlWriter.createPingValidationMessage(paymentDataMsg);
            } else {
                validationMessageXmlWriter.createValidationMessage(paymentDataMsg, validationErrors);
            }
        }
    }
}

